/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.synth;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JMenuBar;
import javax.swing.JToolBar;
import javax.swing.border.AbstractBorder;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthStyle;
import sun.swing.plaf.synth.SynthUI;

class SynthBorder
extends AbstractBorder
implements UIResource {
    private SynthUI ui;
    private Insets insets;

    SynthBorder(SynthUI synthUI, Insets insets) {
        this.ui = synthUI;
        this.insets = insets;
    }

    SynthBorder(SynthUI synthUI) {
        this(synthUI, null);
    }

    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        JComponent jComponent = (JComponent)component;
        SynthContext synthContext = this.ui.getContext(jComponent);
        SynthStyle synthStyle = synthContext.getStyle();
        if (synthStyle == null) {
            assert (false) : "SynthBorder is being used outside after the UI has been uninstalled";
            return;
        }
        this.ui.paintBorder(synthContext, graphics, n, n2, n3, n4);
        synthContext.dispose();
    }

    public Insets getBorderInsets(Component component) {
        return this.getBorderInsets(component, null);
    }

    public Insets getBorderInsets(Component component, Insets insets) {
        if (this.insets != null) {
            if (insets == null) {
                insets = new Insets(this.insets.top, this.insets.left, this.insets.bottom, this.insets.right);
            } else {
                insets.top = this.insets.top;
                insets.bottom = this.insets.bottom;
                insets.left = this.insets.left;
                insets.right = this.insets.left;
            }
        } else if (insets == null) {
            insets = new Insets(0, 0, 0, 0);
        } else {
            insets.right = 0;
            insets.left = 0;
            insets.bottom = 0;
            insets.top = 0;
        }
        if (component instanceof JComponent) {
            Region region = Region.getRegion((JComponent)component);
            Insets insets2 = null;
            if ((region == Region.ARROW_BUTTON || region == Region.BUTTON || region == Region.CHECK_BOX || region == Region.CHECK_BOX_MENU_ITEM || region == Region.MENU || region == Region.MENU_ITEM || region == Region.RADIO_BUTTON || region == Region.RADIO_BUTTON_MENU_ITEM || region == Region.TOGGLE_BUTTON) && component instanceof AbstractButton) {
                insets2 = ((AbstractButton)component).getMargin();
            } else if (region == Region.TOOL_BAR && component instanceof JToolBar) {
                insets2 = ((JToolBar)component).getMargin();
            } else if (region == Region.MENU_BAR && component instanceof JMenuBar) {
                insets2 = ((JMenuBar)component).getMargin();
            }
            if (insets2 != null) {
                insets.top += insets2.top;
                insets.bottom += insets2.bottom;
                insets.left += insets2.left;
                insets.right += insets2.right;
            }
        }
        return insets;
    }

    public boolean isBorderOpaque() {
        return false;
    }
}

