/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import sun.util.calendar.BaseCalendar;
import sun.util.calendar.CalendarSystem;
import sun.util.calendar.CalendarUtils;
import sun.util.calendar.ZoneInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Date
implements Serializable,
Cloneable,
Comparable<Date> {
    private static final BaseCalendar gcal = CalendarSystem.getGregorianCalendar();
    private static BaseCalendar jcal;
    private transient long fastTime;
    private transient BaseCalendar.Date cdate;
    private static int defaultCenturyStart;
    private static final long serialVersionUID = 7523967970034938905L;
    private static final String[] wtb;
    private static final int[] ttb;

    public Date() {
        this(System.currentTimeMillis());
    }

    public Date(long l) {
        this.fastTime = l;
    }

    @Deprecated
    public Date(int n, int n2, int n3) {
        this(n, n2, n3, 0, 0, 0);
    }

    @Deprecated
    public Date(int n, int n2, int n3, int n4, int n5) {
        this(n, n2, n3, n4, n5, 0);
    }

    @Deprecated
    public Date(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = n + 1900;
        if (n2 >= 12) {
            n7 += n2 / 12;
            n2 %= 12;
        } else if (n2 < 0) {
            n7 += CalendarUtils.floorDivide(n2, 12);
            n2 = CalendarUtils.mod(n2, 12);
        }
        BaseCalendar baseCalendar = Date.getCalendarSystem(n7);
        this.cdate = (BaseCalendar.Date)baseCalendar.newCalendarDate(TimeZone.getDefaultRef());
        this.cdate.setNormalizedDate(n7, n2 + 1, n3).setTimeOfDay(n4, n5, n6, 0);
        this.getTimeImpl();
        this.cdate = null;
    }

    @Deprecated
    public Date(String string) {
        this(Date.parse(string));
    }

    public Object clone() {
        Date date = null;
        try {
            date = (Date)super.clone();
            if (this.cdate != null) {
                date.cdate = (BaseCalendar.Date)this.cdate.clone();
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return date;
    }

    @Deprecated
    public static long UTC(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = n + 1900;
        if (n2 >= 12) {
            n7 += n2 / 12;
            n2 %= 12;
        } else if (n2 < 0) {
            n7 += CalendarUtils.floorDivide(n2, 12);
            n2 = CalendarUtils.mod(n2, 12);
        }
        int n8 = n2 + 1;
        BaseCalendar baseCalendar = Date.getCalendarSystem(n7);
        BaseCalendar.Date date = (BaseCalendar.Date)baseCalendar.newCalendarDate(null);
        date.setNormalizedDate(n7, n8, n3).setTimeOfDay(n4, n5, n6, 0);
        Date date2 = new Date(0L);
        date2.normalize(date);
        return date2.fastTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Deprecated
    public static long parse(String string) {
        int n = Integer.MIN_VALUE;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        int n7 = -1;
        int n8 = -1;
        int n9 = 0;
        int n10 = -1;
        int n11 = -1;
        int n12 = -1;
        int n13 = 0;
        if (string == null) {
            throw new IllegalArgumentException();
        }
        int n14 = string.length();
        block2: while (true) {
            int n15;
            block52: {
                block51: {
                    block50: {
                        if (n9 >= n14) break block50;
                        n8 = string.charAt(n9);
                        ++n9;
                        if (n8 <= 32 || n8 == 44) continue;
                        if (n8 == 40) break block51;
                        if (48 <= n8 && n8 <= 57) {
                            n10 = n8 - 48;
                            while (n9 < n14) {
                                char c = string.charAt(n9);
                                n8 = c;
                                if ('0' > c || n8 > 57) break;
                                n10 = n10 * 10 + n8 - 48;
                                ++n9;
                            }
                            if (n13 == 43 || n13 == 45 && n != Integer.MIN_VALUE) {
                                n10 = n10 < 24 ? (n10 *= 60) : n10 % 100 + n10 / 100 * 60;
                                if (n13 == 43) {
                                    n10 = -n10;
                                }
                                if (n12 != 0 && n12 != -1) {
                                    throw new IllegalArgumentException();
                                }
                                n12 = n10;
                            } else if (n10 >= 70) {
                                if (n != Integer.MIN_VALUE) {
                                    throw new IllegalArgumentException();
                                }
                                if (n8 > 32 && n8 != 44 && n8 != 47) {
                                    if (n9 < n14) throw new IllegalArgumentException();
                                }
                                n = n10;
                            } else if (n8 == 58) {
                                if (n4 < 0) {
                                    n4 = (byte)n10;
                                } else {
                                    if (n5 >= 0) throw new IllegalArgumentException();
                                    n5 = (byte)n10;
                                }
                            } else if (n8 == 47) {
                                if (n2 < 0) {
                                    n2 = (byte)(n10 - 1);
                                } else {
                                    if (n3 >= 0) throw new IllegalArgumentException();
                                    n3 = (byte)n10;
                                }
                            } else {
                                if (n9 < n14 && n8 != 44 && n8 > 32 && n8 != 45) {
                                    throw new IllegalArgumentException();
                                }
                                if (n4 >= 0 && n5 < 0) {
                                    n5 = (byte)n10;
                                } else if (n5 >= 0 && n6 < 0) {
                                    n6 = (byte)n10;
                                } else if (n3 < 0) {
                                    n3 = (byte)n10;
                                } else {
                                    if (n != Integer.MIN_VALUE) throw new IllegalArgumentException();
                                    if (n2 < 0) throw new IllegalArgumentException();
                                    if (n3 < 0) throw new IllegalArgumentException();
                                    n = n10;
                                }
                            }
                            n13 = 0;
                            continue;
                        }
                        if (n8 == 47 || n8 == 58 || n8 == 43 || n8 == 45) {
                            n13 = n8;
                            continue;
                        }
                        n15 = n9 - 1;
                        break block52;
                    }
                    if (n == Integer.MIN_VALUE) throw new IllegalArgumentException();
                    if (n2 < 0) throw new IllegalArgumentException();
                    if (n3 < 0) {
                        throw new IllegalArgumentException();
                    }
                    if (n < 100) {
                        Class<Date> clazz = Date.class;
                        // MONITORENTER : java.util.Date.class
                        if (defaultCenturyStart == 0) {
                            defaultCenturyStart = gcal.getCalendarDate().getYear() - 80;
                        }
                        // MONITOREXIT : clazz
                        if ((n += defaultCenturyStart / 100 * 100) < defaultCenturyStart) {
                            n += 100;
                        }
                    }
                    if (n6 < 0) {
                        n6 = 0;
                    }
                    if (n5 < 0) {
                        n5 = 0;
                    }
                    if (n4 < 0) {
                        n4 = 0;
                    }
                    BaseCalendar baseCalendar = Date.getCalendarSystem(n);
                    if (n12 == -1) {
                        BaseCalendar.Date date = (BaseCalendar.Date)baseCalendar.newCalendarDate(TimeZone.getDefaultRef());
                        date.setDate(n, n2 + 1, n3);
                        date.setTimeOfDay(n4, n5, n6, 0);
                        return baseCalendar.getTime(date);
                    }
                    BaseCalendar.Date date = (BaseCalendar.Date)baseCalendar.newCalendarDate(null);
                    date.setDate(n, n2 + 1, n3);
                    date.setTimeOfDay(n4, n5, n6, 0);
                    return baseCalendar.getTime(date) + (long)(n12 * 60000);
                }
                n15 = 1;
                while (true) {
                    if (n9 >= n14) continue block2;
                    n8 = string.charAt(n9);
                    ++n9;
                    if (n8 == 40) {
                        ++n15;
                        continue;
                    }
                    if (n8 == 41 && --n15 <= 0) break;
                }
                continue;
            }
            while (n9 < n14 && (65 <= (n8 = (int)string.charAt(n9)) && n8 <= 90 || 97 <= n8 && n8 <= 122)) {
                ++n9;
            }
            if (n9 <= n15 + 1) {
                throw new IllegalArgumentException();
            }
            int n16 = wtb.length;
            while (--n16 >= 0) {
                if (!wtb[n16].regionMatches(true, 0, string, n15, n9 - n15)) continue;
                int n17 = ttb[n16];
                if (n17 == 0) break;
                if (n17 == 1) {
                    if (n4 > 12) throw new IllegalArgumentException();
                    if (n4 < 1) {
                        throw new IllegalArgumentException();
                    }
                    if (n4 >= 12) break;
                    n4 += 12;
                    break;
                }
                if (n17 == 14) {
                    if (n4 > 12) throw new IllegalArgumentException();
                    if (n4 < 1) {
                        throw new IllegalArgumentException();
                    }
                    if (n4 != 12) break;
                    n4 = 0;
                    break;
                }
                if (n17 <= 13) {
                    if (n2 >= 0) throw new IllegalArgumentException();
                    n2 = (byte)(n17 - 2);
                    break;
                }
                n12 = n17 - 10000;
                break;
            }
            if (n16 < 0) {
                throw new IllegalArgumentException();
            }
            n13 = 0;
        }
    }

    @Deprecated
    public int getYear() {
        return this.normalize().getYear() - 1900;
    }

    @Deprecated
    public void setYear(int n) {
        this.getCalendarDate().setNormalizedYear(n + 1900);
    }

    @Deprecated
    public int getMonth() {
        return this.normalize().getMonth() - 1;
    }

    @Deprecated
    public void setMonth(int n) {
        int n2 = 0;
        if (n >= 12) {
            n2 = n / 12;
            n %= 12;
        } else if (n < 0) {
            n2 = CalendarUtils.floorDivide(n, 12);
            n = CalendarUtils.mod(n, 12);
        }
        BaseCalendar.Date date = this.getCalendarDate();
        if (n2 != 0) {
            date.setNormalizedYear(date.getNormalizedYear() + n2);
        }
        date.setMonth(n + 1);
    }

    @Deprecated
    public int getDate() {
        return this.normalize().getDayOfMonth();
    }

    @Deprecated
    public void setDate(int n) {
        this.getCalendarDate().setDayOfMonth(n);
    }

    @Deprecated
    public int getDay() {
        return this.normalize().getDayOfWeek() - 1;
    }

    @Deprecated
    public int getHours() {
        return this.normalize().getHours();
    }

    @Deprecated
    public void setHours(int n) {
        this.getCalendarDate().setHours(n);
    }

    @Deprecated
    public int getMinutes() {
        return this.normalize().getMinutes();
    }

    @Deprecated
    public void setMinutes(int n) {
        this.getCalendarDate().setMinutes(n);
    }

    @Deprecated
    public int getSeconds() {
        return this.normalize().getSeconds();
    }

    @Deprecated
    public void setSeconds(int n) {
        this.getCalendarDate().setSeconds(n);
    }

    public long getTime() {
        return this.getTimeImpl();
    }

    private final long getTimeImpl() {
        if (this.cdate != null && !this.cdate.isNormalized()) {
            this.normalize();
        }
        return this.fastTime;
    }

    public void setTime(long l) {
        this.fastTime = l;
        this.cdate = null;
    }

    public boolean before(Date date) {
        return Date.getMillisOf(this) < Date.getMillisOf(date);
    }

    public boolean after(Date date) {
        return Date.getMillisOf(this) > Date.getMillisOf(date);
    }

    public boolean equals(Object object) {
        return object instanceof Date && this.getTime() == ((Date)object).getTime();
    }

    static final long getMillisOf(Date date) {
        if (date.cdate == null) {
            return date.fastTime;
        }
        BaseCalendar.Date date2 = (BaseCalendar.Date)date.cdate.clone();
        return gcal.getTime(date2);
    }

    @Override
    public int compareTo(Date date) {
        long l;
        long l2 = Date.getMillisOf(this);
        return l2 < (l = Date.getMillisOf(date)) ? -1 : (l2 == l ? 0 : 1);
    }

    public int hashCode() {
        long l = this.getTime();
        return (int)l ^ (int)(l >> 32);
    }

    public String toString() {
        BaseCalendar.Date date = this.normalize();
        StringBuilder stringBuilder = new StringBuilder(28);
        int n = date.getDayOfWeek();
        if (n == 1) {
            n = 8;
        }
        Date.convertToAbbr(stringBuilder, wtb[n]).append(' ');
        Date.convertToAbbr(stringBuilder, wtb[date.getMonth() - 1 + 2 + 7]).append(' ');
        CalendarUtils.sprintf0d(stringBuilder, date.getDayOfMonth(), 2).append(' ');
        CalendarUtils.sprintf0d(stringBuilder, date.getHours(), 2).append(':');
        CalendarUtils.sprintf0d(stringBuilder, date.getMinutes(), 2).append(':');
        CalendarUtils.sprintf0d(stringBuilder, date.getSeconds(), 2).append(' ');
        TimeZone timeZone = date.getZone();
        if (timeZone != null) {
            stringBuilder.append(timeZone.getDisplayName(date.isDaylightTime(), 0, Locale.US));
        } else {
            stringBuilder.append("GMT");
        }
        stringBuilder.append(' ').append(date.getYear());
        return stringBuilder.toString();
    }

    private static final StringBuilder convertToAbbr(StringBuilder stringBuilder, String string) {
        stringBuilder.append(Character.toUpperCase(string.charAt(0)));
        stringBuilder.append(string.charAt(1)).append(string.charAt(2));
        return stringBuilder;
    }

    @Deprecated
    public String toLocaleString() {
        DateFormat dateFormat = DateFormat.getDateTimeInstance();
        return dateFormat.format(this);
    }

    @Deprecated
    public String toGMTString() {
        long l = this.getTime();
        BaseCalendar baseCalendar = Date.getCalendarSystem(l);
        BaseCalendar.Date date = (BaseCalendar.Date)baseCalendar.getCalendarDate(this.getTime(), (TimeZone)null);
        StringBuilder stringBuilder = new StringBuilder(32);
        CalendarUtils.sprintf0d(stringBuilder, date.getDayOfMonth(), 1).append(' ');
        Date.convertToAbbr(stringBuilder, wtb[date.getMonth() - 1 + 2 + 7]).append(' ');
        stringBuilder.append(date.getYear()).append(' ');
        CalendarUtils.sprintf0d(stringBuilder, date.getHours(), 2).append(':');
        CalendarUtils.sprintf0d(stringBuilder, date.getMinutes(), 2).append(':');
        CalendarUtils.sprintf0d(stringBuilder, date.getSeconds(), 2);
        stringBuilder.append(" GMT");
        return stringBuilder.toString();
    }

    @Deprecated
    public int getTimezoneOffset() {
        int n;
        if (this.cdate == null) {
            TimeZone timeZone = TimeZone.getDefaultRef();
            n = timeZone instanceof ZoneInfo ? ((ZoneInfo)timeZone).getOffsets(this.fastTime, null) : timeZone.getOffset(this.fastTime);
        } else {
            this.normalize();
            n = this.cdate.getZoneOffset();
        }
        return -n / 60000;
    }

    private final BaseCalendar.Date getCalendarDate() {
        if (this.cdate == null) {
            BaseCalendar baseCalendar = Date.getCalendarSystem(this.fastTime);
            this.cdate = (BaseCalendar.Date)baseCalendar.getCalendarDate(this.fastTime, TimeZone.getDefaultRef());
        }
        return this.cdate;
    }

    private final BaseCalendar.Date normalize() {
        TimeZone timeZone;
        if (this.cdate == null) {
            BaseCalendar baseCalendar = Date.getCalendarSystem(this.fastTime);
            this.cdate = (BaseCalendar.Date)baseCalendar.getCalendarDate(this.fastTime, TimeZone.getDefaultRef());
            return this.cdate;
        }
        if (!this.cdate.isNormalized()) {
            this.cdate = this.normalize(this.cdate);
        }
        if ((timeZone = TimeZone.getDefaultRef()) != this.cdate.getZone()) {
            this.cdate.setZone(timeZone);
            BaseCalendar baseCalendar = Date.getCalendarSystem(this.cdate);
            ((CalendarSystem)baseCalendar).getCalendarDate(this.fastTime, this.cdate);
        }
        return this.cdate;
    }

    private final BaseCalendar.Date normalize(BaseCalendar.Date date) {
        int n = date.getNormalizedYear();
        int n2 = date.getMonth();
        int n3 = date.getDayOfMonth();
        int n4 = date.getHours();
        int n5 = date.getMinutes();
        int n6 = date.getSeconds();
        int n7 = date.getMillis();
        TimeZone timeZone = date.getZone();
        if (n == 1582 || n > 280000000 || n < -280000000) {
            if (timeZone == null) {
                timeZone = TimeZone.getTimeZone("GMT");
            }
            GregorianCalendar gregorianCalendar = new GregorianCalendar(timeZone);
            gregorianCalendar.clear();
            gregorianCalendar.set(14, n7);
            gregorianCalendar.set(n, n2 - 1, n3, n4, n5, n6);
            this.fastTime = gregorianCalendar.getTimeInMillis();
            BaseCalendar baseCalendar = Date.getCalendarSystem(this.fastTime);
            date = (BaseCalendar.Date)baseCalendar.getCalendarDate(this.fastTime, timeZone);
            return date;
        }
        BaseCalendar baseCalendar = Date.getCalendarSystem(n);
        if (baseCalendar != Date.getCalendarSystem(date)) {
            date = (BaseCalendar.Date)baseCalendar.newCalendarDate(timeZone);
            date.setNormalizedDate(n, n2, n3).setTimeOfDay(n4, n5, n6, n7);
        }
        this.fastTime = baseCalendar.getTime(date);
        BaseCalendar baseCalendar2 = Date.getCalendarSystem(this.fastTime);
        if (baseCalendar2 != baseCalendar) {
            date = (BaseCalendar.Date)baseCalendar2.newCalendarDate(timeZone);
            date.setNormalizedDate(n, n2, n3).setTimeOfDay(n4, n5, n6, n7);
            this.fastTime = baseCalendar2.getTime(date);
        }
        return date;
    }

    private static final BaseCalendar getCalendarSystem(int n) {
        if (n >= 1582) {
            return gcal;
        }
        return Date.getJulianCalendar();
    }

    private static final BaseCalendar getCalendarSystem(long l) {
        if (l >= -12219292800000L) {
            return gcal;
        }
        return Date.getJulianCalendar();
    }

    private static final BaseCalendar getCalendarSystem(BaseCalendar.Date date) {
        if (jcal == null) {
            return gcal;
        }
        if (date.getEra() != null) {
            return jcal;
        }
        return gcal;
    }

    private static final synchronized BaseCalendar getJulianCalendar() {
        if (jcal == null) {
            jcal = (BaseCalendar)CalendarSystem.forName("julian");
        }
        return jcal;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeLong(this.getTimeImpl());
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.fastTime = objectInputStream.readLong();
    }

    static {
        wtb = new String[]{"am", "pm", "monday", "tuesday", "wednesday", "thursday", "friday", "saturday", "sunday", "january", "february", "march", "april", "may", "june", "july", "august", "september", "october", "november", "december", "gmt", "ut", "utc", "est", "edt", "cst", "cdt", "mst", "mdt", "pst", "pdt"};
        ttb = new int[]{14, 1, 0, 0, 0, 0, 0, 0, 0, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 10000, 10000, 10000, 10300, 10240, 10360, 10300, 10420, 10360, 10480, 10420};
    }
}

