/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.util;

import com.sun.deploy.config.Config;
import com.sun.deploy.util.Trace;
import com.sun.deploy.util.TraceLevel;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.BitSet;

public class URLUtil {
    private static boolean doIPLookup = true;
    static BitSet encodedInPath = new BitSet(256);
    private static File HOST_FILE_DIR;

    public static void setDoIPLookup(boolean bl) {
        doIPLookup = bl;
    }

    private static String getCurrentIP(String string, String string2) {
        Method method;
        if (string == null || string2 == null) {
            return null;
        }
        if (!doIPLookup) {
            return null;
        }
        String string3 = null;
        Class<?> clazz = null;
        try {
            clazz = Class.forName("java.net.InetAddress");
        }
        catch (ClassNotFoundException classNotFoundException) {
            Trace.ignoredException(classNotFoundException);
            return null;
        }
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getByName(string2);
        }
        catch (UnknownHostException unknownHostException) {
            Trace.ignoredException(unknownHostException);
        }
        Object[] objectArray = new Object[]{string, inetAddress};
        Class[] classArray = new Class[2];
        try {
            classArray[0] = Class.forName("java.lang.String");
            classArray[1] = clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            Trace.ignoredException(classNotFoundException);
            return null;
        }
        try {
            method = clazz.getDeclaredMethod("getByName", classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Trace.ignoredException(noSuchMethodException);
            return null;
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                method.setAccessible(true);
                return null;
            }
        });
        if (!Modifier.isStatic(method.getModifiers())) {
            return null;
        }
        InetAddress inetAddress2 = null;
        try {
            inetAddress2 = (InetAddress)method.invoke((Object)null, objectArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            Trace.ignoredException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Trace.ignoredException(invocationTargetException);
        }
        if (inetAddress2 != null) {
            string3 = inetAddress2.getHostAddress();
        }
        return string3;
    }

    protected static int hashCode(String string) {
        int n = string.hashCode();
        n += ~(n << 9);
        n ^= n >>> 14;
        n += n << 4;
        n ^= n >>> 10;
        return n;
    }

    private static File getHostFile(String string) {
        int n = URLUtil.hashCode(string.toLowerCase());
        if (n < 0) {
            n -= Integer.MIN_VALUE;
        }
        String string2 = Integer.toString(n, 16);
        return new File(HOST_FILE_DIR, string2 + ".hst");
    }

    public static void updateSocketHostIPFile(String string) {
        if (string == null) {
            return;
        }
        File file = URLUtil.getHostFile(string);
        boolean bl = file.exists();
        if (bl) {
            String string2 = URLUtil.getIPFromFile(file);
            URLUtil.isCachedHostIPValid(string, string2, file);
        } else {
            URLUtil.createHostFile(string, file);
        }
    }

    public static boolean isCachedHostIPValid(String string, String string2, File file) {
        boolean bl = true;
        if (string2 == null) {
            return bl;
        }
        String string3 = URLUtil.getCurrentIP(string, string2);
        if (string3 == null) {
            return true;
        }
        if (!string3.equals(string2)) {
            bl = false;
        }
        if (file != null && string2 != null && !string3.equals(string2)) {
            URLUtil.updateHostFile(string, file);
        }
        return bl;
    }

    private static void updateHostFile(String string, final File file) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                file.delete();
                return null;
            }
        });
        URLUtil.createHostFile(string, file);
    }

    public static String getIPFromFile(final File file) {
        String string = null;
        if (file == null) {
            return null;
        }
        string = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String string = null;
                try {
                    BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                    string = bufferedReader.readLine();
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return string;
            }
        });
        return string;
    }

    public static String getHostIP(String string) {
        if (!doIPLookup) {
            return null;
        }
        String string2 = null;
        InetAddress inetAddress = null;
        if (string == null) {
            return string2;
        }
        try {
            inetAddress = InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            Trace.ignoredException(unknownHostException);
        }
        if (inetAddress != null) {
            string2 = inetAddress.getHostAddress();
        }
        return string2;
    }

    public static void createHostFile(String string, final File file) {
        if (string == null || file == null) {
            return;
        }
        final String string2 = URLUtil.getHostIP(string);
        if (string2 != null) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
                        bufferedWriter.write(string2);
                        bufferedWriter.close();
                    }
                    catch (IOException iOException) {
                        Trace.ignoredException(iOException);
                    }
                    return null;
                }
            });
        }
    }

    public static void setHostHeader(URLConnection uRLConnection) {
        int n = uRLConnection.getURL().getPort();
        String string = uRLConnection.getURL().getHost();
        if (n != -1 && n != 80) {
            string = string + ":" + String.valueOf(n);
        }
        uRLConnection.setRequestProperty("Host", string);
    }

    public static URL getBase(URL uRL) {
        if (uRL == null) {
            return null;
        }
        String string = uRL.getFile();
        if (string != null) {
            int n = string.lastIndexOf(47);
            if (n != -1) {
                string = string.substring(0, n + 1);
            }
            try {
                return new URL(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), string);
            }
            catch (MalformedURLException malformedURLException) {
                Trace.ignoredException(malformedURLException);
            }
        }
        return uRL;
    }

    public static URL asPathURL(URL uRL) {
        if (uRL == null) {
            return null;
        }
        String string = uRL.getFile();
        if (string != null && !string.endsWith("/")) {
            try {
                return new URL(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), uRL.getFile() + "/");
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return uRL;
    }

    public static boolean equals(URL uRL, URL uRL2) {
        if (uRL == null || uRL2 == null) {
            return uRL2 == uRL;
        }
        if ("http".equals(uRL.getProtocol()) && "http".equals(uRL2.getProtocol()) && uRL.getPort() != uRL2.getPort()) {
            uRL = URLUtil.normalizePort(uRL);
            uRL2 = URLUtil.normalizePort(uRL2);
        }
        return uRL.toString().equals(uRL2.toString());
    }

    public static int compareTo(URL uRL, URL uRL2) {
        if ("http".equals(uRL.getProtocol()) && "http".equals(uRL2.getProtocol()) && uRL.getPort() != uRL2.getPort()) {
            uRL = URLUtil.normalizePort(uRL);
            uRL2 = URLUtil.normalizePort(uRL2);
        }
        return uRL.toString().compareTo(uRL2.toString());
    }

    private static URL normalizePort(URL uRL) {
        if (uRL.getPort() != -1) {
            return uRL;
        }
        try {
            return new URL(uRL.getProtocol(), uRL.getHost(), 80, uRL.getFile());
        }
        catch (MalformedURLException malformedURLException) {
            return uRL;
        }
    }

    public static String encodePath(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == File.separatorChar) {
                stringBuffer.append('/');
                continue;
            }
            if (c <= '\u007f') {
                if (encodedInPath.get(c)) {
                    URLUtil.escape(stringBuffer, c);
                    continue;
                }
                stringBuffer.append(c);
                continue;
            }
            if (c > '\u07ff') {
                URLUtil.escape(stringBuffer, (char)(0xE0 | c >> 12 & 0xF));
                URLUtil.escape(stringBuffer, (char)(0x80 | c >> 6 & 0x3F));
                URLUtil.escape(stringBuffer, (char)(0x80 | c >> 0 & 0x3F));
                continue;
            }
            URLUtil.escape(stringBuffer, (char)(0xC0 | c >> 6 & 0x1F));
            URLUtil.escape(stringBuffer, (char)(0x80 | c >> 0 & 0x3F));
        }
        if (!string.equals(stringBuffer.toString())) {
            Trace.println("     String: " + string, TraceLevel.BASIC);
            Trace.println(" encoded to: " + stringBuffer.toString(), TraceLevel.BASIC);
        }
        return stringBuffer.toString();
    }

    private static void escape(StringBuffer stringBuffer, char c) {
        stringBuffer.append('%');
        stringBuffer.append(Character.forDigit(c >> 4 & 0xF, 16));
        stringBuffer.append(Character.forDigit(c & 0xF, 16));
    }

    public static String decodePath(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c != '%') {
                ++n;
            } else {
                try {
                    c = URLUtil.unescape(string, n);
                    n += 3;
                    if ((c & 0x80) != 0) {
                        switch (c >> 4) {
                            case 12: 
                            case 13: {
                                char c2 = URLUtil.unescape(string, n);
                                n += 3;
                                c = (char)((c & 0x1F) << 6 | c2 & 0x3F);
                                break;
                            }
                            case 14: {
                                char c2 = URLUtil.unescape(string, n);
                                char c3 = URLUtil.unescape(string, n += 3);
                                n += 3;
                                c = (char)((c & 0xF) << 12 | (c2 & 0x3F) << 6 | c3 & 0x3F);
                                break;
                            }
                            default: {
                                Trace.ignoredException(new IllegalArgumentException());
                            }
                        }
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    Trace.ignoredException(numberFormatException);
                }
            }
            stringBuffer.append(c);
        }
        if (!string.equals(stringBuffer.toString())) {
            Trace.println("     String: " + string, TraceLevel.BASIC);
            Trace.println(" decoded to: " + stringBuffer.toString(), TraceLevel.BASIC);
        }
        return stringBuffer.toString();
    }

    private static char unescape(String string, int n) {
        return (char)Integer.parseInt(string.substring(n + 1, n + 3), 16);
    }

    public static String getEncodedPath(File file) {
        String string = file.getAbsolutePath();
        if (!string.endsWith(File.separator) && file.isDirectory()) {
            string = string + File.separator;
        }
        return URLUtil.encodePath(string);
    }

    public static String getDecodedPath(URL uRL) {
        String string = uRL.getFile();
        string = string.replace('/', File.separatorChar);
        return URLUtil.decodePath(string);
    }

    public static String getPathFromURL(URL uRL) {
        return URLUtil.getDecodedPath(uRL);
    }

    static {
        encodedInPath.set(61);
        encodedInPath.set(59);
        encodedInPath.set(63);
        encodedInPath.set(47);
        encodedInPath.set(35);
        encodedInPath.set(32);
        encodedInPath.set(60);
        encodedInPath.set(62);
        encodedInPath.set(37);
        encodedInPath.set(34);
        encodedInPath.set(123);
        encodedInPath.set(125);
        encodedInPath.set(124);
        encodedInPath.set(92);
        encodedInPath.set(94);
        encodedInPath.set(91);
        encodedInPath.set(93);
        encodedInPath.set(96);
        for (int i = 0; i < 32; ++i) {
            encodedInPath.set(i);
        }
        encodedInPath.set(127);
        HOST_FILE_DIR = new File(Config.getUserHome() + File.separator + "host");
        HOST_FILE_DIR.mkdirs();
    }
}

