/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.util;

import com.sun.deploy.config.Config;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.util.ConsoleController;
import java.util.Iterator;
import java.util.Properties;
import java.util.TreeSet;

public final class ConsoleHelper {
    private static ConsoleController controller = null;

    public static void setConsoleController(ConsoleController consoleController) {
        controller = consoleController;
    }

    static void dumpThreadGroup(ThreadGroup threadGroup, StringBuffer stringBuffer) {
        if (threadGroup != null) {
            try {
                if (threadGroup.activeCount() == 0 && threadGroup.activeGroupCount() == 0 && !threadGroup.isDestroyed()) {
                    threadGroup.destroy();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            stringBuffer.append("Group " + threadGroup.getName());
            stringBuffer.append(",ac=" + threadGroup.activeCount());
            stringBuffer.append(",agc=" + threadGroup.activeGroupCount());
            stringBuffer.append(",pri=" + threadGroup.getMaxPriority());
            if (threadGroup.isDestroyed()) {
                stringBuffer.append(",destoyed");
            }
            if (threadGroup.isDaemon()) {
                stringBuffer.append(",daemon");
            }
            stringBuffer.append("\n");
            Thread[] threadArray = new Thread[1000];
            threadGroup.enumerate(threadArray, false);
            for (int i = 0; i < threadArray.length; ++i) {
                if (threadArray[i] == null) continue;
                stringBuffer.append("    ");
                stringBuffer.append(threadArray[i].getName());
                stringBuffer.append(",");
                stringBuffer.append(threadArray[i].getPriority());
                if (threadArray[i].isAlive()) {
                    stringBuffer.append(",alive");
                } else {
                    stringBuffer.append(",not alive");
                }
                if (threadArray[i].isDaemon()) {
                    stringBuffer.append(",daemon");
                }
                if (threadArray[i].isInterrupted()) {
                    stringBuffer.append(",interrupted");
                }
                stringBuffer.append("\n");
            }
            ThreadGroup[] threadGroupArray = new ThreadGroup[1000];
            threadGroup.enumerate(threadGroupArray, false);
            for (int i = 0; i < threadGroupArray.length; ++i) {
                if (threadGroupArray[i] == null) continue;
                ConsoleHelper.dumpThreadGroup(threadGroupArray[i], stringBuffer);
            }
        }
    }

    public static String displayHelp() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(ResourceManager.getMessage("console.menu.text.top"));
        stringBuffer.append(ResourceManager.getMessage("console.menu.text.c"));
        stringBuffer.append(ResourceManager.getMessage("console.menu.text.f"));
        stringBuffer.append(ResourceManager.getMessage("console.menu.text.g"));
        stringBuffer.append(ResourceManager.getMessage("console.menu.text.h"));
        if (controller.isJCovSupported()) {
            stringBuffer.append(ResourceManager.getMessage("console.menu.text.j"));
        }
        if (controller.isDumpClassLoaderSupported()) {
            stringBuffer.append(ResourceManager.getMessage("console.menu.text.l"));
        }
        stringBuffer.append(ResourceManager.getMessage("console.menu.text.m"));
        if (controller.isLoggingSupported()) {
            stringBuffer.append(ResourceManager.getMessage("console.menu.text.o"));
        }
        if (controller.isProxyConfigReloadSupported()) {
            stringBuffer.append(ResourceManager.getMessage("console.menu.text.p"));
        }
        stringBuffer.append(ResourceManager.getMessage("console.menu.text.q"));
        if (controller.isSecurityPolicyReloadSupported()) {
            stringBuffer.append(ResourceManager.getMessage("console.menu.text.r"));
        }
        stringBuffer.append(ResourceManager.getMessage("console.menu.text.s"));
        stringBuffer.append(ResourceManager.getMessage("console.menu.text.t"));
        if (controller.isDumpStackSupported()) {
            stringBuffer.append(ResourceManager.getMessage("console.menu.text.v"));
        }
        if (controller.isClearClassLoaderSupported()) {
            stringBuffer.append(ResourceManager.getMessage("console.menu.text.x"));
        }
        stringBuffer.append(ResourceManager.getMessage("console.menu.text.0"));
        stringBuffer.append(ResourceManager.getMessage("console.menu.text.tail"));
        return stringBuffer.toString();
    }

    public static String displayVersion() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(controller.getProductName());
        stringBuffer.append("\n");
        stringBuffer.append(ResourceManager.getMessage("console.using_jre_version"));
        stringBuffer.append(" ");
        stringBuffer.append(System.getProperty("java.version"));
        stringBuffer.append(" ");
        stringBuffer.append(System.getProperty("java.vm.name"));
        stringBuffer.append("\n");
        stringBuffer.append(ResourceManager.getMessage("console.user_home"));
        stringBuffer.append(" = ");
        stringBuffer.append(System.getProperty("user.home"));
        return stringBuffer.toString();
    }

    public static String displaySystemProperties() {
        String string;
        String string2;
        TreeSet<Object> treeSet = new TreeSet<Object>();
        Properties properties = Config.getProperties();
        Object object = System.getProperties().propertyNames();
        while (object.hasMoreElements()) {
            treeSet.add(object.nextElement());
        }
        object = new StringBuffer();
        ((StringBuffer)object).append(ResourceManager.getMessage("console.dump.system.properties"));
        ((StringBuffer)object).append(ResourceManager.getMessage("console.menu.text.top"));
        Iterator iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            string2 = (String)iterator.next();
            if (properties.containsKey(string2)) continue;
            string = System.getProperty(string2);
            if (string != null) {
                if (string.equals("\n")) {
                    string = "\\n";
                } else if (string.equals("\r")) {
                    string = "\\r";
                } else if (string.equals("\r\n")) {
                    string = "\\r\\n";
                } else if (string.equals("\n\r")) {
                    string = "\\n\\r";
                } else if (string.equals("\n\n")) {
                    string = "\\n\\n";
                } else if (string.equals("\r\r")) {
                    string = "\\r\\r";
                }
            }
            ((StringBuffer)object).append(string2 + " = " + string + "\n");
        }
        ((StringBuffer)object).append(ResourceManager.getMessage("console.menu.text.tail"));
        treeSet.clear();
        iterator = properties.propertyNames();
        while (iterator.hasMoreElements()) {
            treeSet.add(iterator.nextElement());
        }
        ((StringBuffer)object).append(ResourceManager.getMessage("console.dump.deployment.properties"));
        ((StringBuffer)object).append(ResourceManager.getMessage("console.menu.text.top"));
        iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            string2 = (String)iterator.next();
            string = properties.getProperty(string2);
            if (string != null) {
                if (string.equals("\n")) {
                    string = "\\n";
                } else if (string.equals("\r")) {
                    string = "\\r";
                } else if (string.equals("\r\n")) {
                    string = "\\r\\n";
                } else if (string.equals("\n\r")) {
                    string = "\\n\\r";
                } else if (string.equals("\n\n")) {
                    string = "\\n\\n";
                } else if (string.equals("\r\r")) {
                    string = "\\r\\r";
                }
            }
            ((StringBuffer)object).append(string2 + " = " + string + "\n");
        }
        ((StringBuffer)object).append(ResourceManager.getMessage("console.menu.text.tail"));
        ((StringBuffer)object).append(ResourceManager.getMessage("console.done"));
        return ((StringBuffer)object).toString();
    }
}

